TITLE   'Cylinder in a Square Bar'                            { exa354b.pde }
SELECT     errlim=1e-3  spectral_colors		
COORDINATES     cartesian3
VARIABLES   U
DEFINITIONS
   r0=2e-3     d0=4e-3     h=20e-3     cond
   Ex=-dx( U)     Ey=-dy( U)     Ez=-dz( U)
   E=-grad( U)     Em=magnitude( E)
   Jx=cond*Ex     Jy=cond*Ey     Jz=cond*Ez
   J=cond*E     Jm=magnitude( J)
   rad=sqrt( x^2+ y^2)					{ Radius }
   power=vol_integral( Jm*Em)			{ Dissipation }
   current=surf_integral( normal( J),'top')	
EQUATIONS
   div( J)=0
EXTRUSION
   surface 'bottom' z=0	{ Flat base }
   surface 'top' z=h					{ Flat upper surface }
BOUNDARIES
   surface 'bottom'   value( U)=0
   surface 'top' value( U)=1.0				{ 1 volt applied on top }
region 'square bar'	cond=1			{ Total region minus cylinder }
!   surface 'bar' natural( U)=0			{ dU/dn=0 on cone }
   start (-d0, -d0) natural( U)=0 line to (d0,-d0) to (d0,d0) to (-d0,d0)   to finish
region 'cylinder'	cond=100					{ Overwrites total }
   surface 'bottom' value( U)=0				{ Lower flat face }	
   start (r0, 0)  arc( center=0,0) angle=360 to finish
PLOTS
   grid( x,y,z) report(power) report(current)
   contour( U) on x=0     vector( J) norm on x=0
{   elevation( tangential( E))
       line_integrate from (0,r1/2,h) to (0,0,0)  }	{ Voltage }
END
